import os
from pdf2image import convert_from_path
from PIL import Image
import pytesseract

os.environ["Path"] += os.pathsep + r"C:\poppler\poppler-23.11.0\Library\bin"
# Path to Tesseract
pytesseract.pytesseract.tesseract_cmd = r"C:\Program Files\Tesseract-OCR\tesseract.exe"

def extract_text_from_image(file_path):
    try:
        if file_path.lower().endswith('.pdf'):
            pages = convert_from_path(file_path)
            text = ''
            for page in pages:
                text += pytesseract.image_to_string(page)
            return text
        else:
            image = Image.open(file_path)
            return pytesseract.image_to_string(image)
    except Exception as e:
        return f"Error during OCR: {str(e)}"
